VERSION 5.00
Begin VB.Form frmError 
   Caption         =   "Errors"
   ClientHeight    =   3195
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   2145
   LinkTopic       =   "Form1"
   ScaleHeight     =   3195
   ScaleWidth      =   2145
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdError 
      Caption         =   "Wrong Data Type"
      Height          =   375
      Index           =   5
      Left            =   120
      TabIndex        =   5
      Top             =   2520
      Width           =   1815
   End
   Begin VB.CommandButton cmdError 
      Caption         =   "Locked Record"
      Height          =   375
      Index           =   2
      Left            =   120
      TabIndex        =   4
      Top             =   1080
      Width           =   1815
   End
   Begin VB.CommandButton cmdError 
      Caption         =   "Invalid Table"
      Height          =   375
      Index           =   0
      Left            =   120
      TabIndex        =   3
      Top             =   120
      Width           =   1815
   End
   Begin VB.CommandButton cmdError 
      Caption         =   "No Current Record"
      Height          =   375
      Index           =   4
      Left            =   120
      TabIndex        =   2
      Top             =   2040
      Width           =   1815
   End
   Begin VB.CommandButton cmdError 
      Caption         =   "Invalid Field"
      Height          =   375
      Index           =   1
      Left            =   120
      TabIndex        =   1
      Top             =   600
      Width           =   1815
   End
   Begin VB.CommandButton cmdError 
      Caption         =   "Deleted Record"
      Height          =   375
      Index           =   3
      Left            =   120
      TabIndex        =   0
      Top             =   1560
      Width           =   1815
   End
End
Attribute VB_Name = "frmError"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Dim objConn As ADODB.Connection
Dim objRec As ADODB.Recordset

Const INVALID_TABLE = -2147217865
Const INVALID_FIELD = 3265
Const TABLE_LOCKED = 3251
Const DELETED_RECORD = -2147217885
Const NO_CURRENT_RECORD = 3219
Const WRONG_DATA_TYPE = -2147352571

Private Sub Command1_Click(Index As Integer)

End Sub

Private Sub Form_Load()

  Set objConn = New ADODB.Connection
  objConn.ConnectionString = "Provider=SQLOLEDB.1;" & _
                             "Persist Security Info=False;" & _
                             "User ID=sa;Initial Catalog=pubs"
  objConn.Open

End Sub

Private Sub cmdError_Click(Index As Integer)

  Set objRec = New ADODB.Recordset

  On Error GoTo errHandler

   Select Case Index

     Case 0
       ' Error caused by invalid Table Name
       objRec.Open "FakeTableName", objConn, , , adCmdTable
       MsgBox "This line of code is called after calling 'Resume Next'"

     Case 1
       ' Error caused by invalid Field Name
       objRec.Open "Employee", objConn, , , adCmdTable
       MsgBox objRec("InvalidField")

     Case 2
       ' Error caused by failing to unlock the table
       objRec.Open "Employee", objConn, , , adCmdTable
       objRec.Delete adAffectCurrent

     Case 3
       ' Error caused by calling a field of a deleted record
       objRec.LockType = adLockOptimistic
       objRec.Open "Employee_BK", objConn, , , adCmdTable
       objRec.Delete adAffectCurrent
       MsgBox objRec("emp_id")

     Case 4
       ' Error caused by navigating beyond the BOF marker
       objRec.Open "Employee", objConn, , , adCmdTable
       objRec.MoveFirst
       objRec.MovePrevious

     Case 5
       ' Error caused by entering data of the wrong type
       objRec.LockType = adLockOptimistic
       objRec.Open "Employee_BK", objConn, , , adCmdTable
       objRec("job_id") = "EM"

    End Select
   Exit Sub


NextLine:
   MsgBox "This line is only called after calling 'Resume NextLine'"
   Exit Sub

errHandler:

   Select Case Err.Number

      Case INVALID_TABLE       ' Table not found
         ErrorLog "Table not found in database! "
         Resume Next

      Case INVALID_FIELD       ' Field not found
         ErrorLog "Field not found in table! "
         Resume NextLine

      Case TABLE_LOCKED        ' Table Locked
         ErrorLog Err.Description & " Use Optimistic Locking!"

      Case DELETED_RECORD      ' Deleted Record
         ErrorLog "The requested field of the current record" & _
                  " has been deleted!"

      Case NO_CURRENT_RECORD   ' No Current Record
         ErrorLog "There is no current record!"

      Case WRONG_DATA_TYPE     ' Wrong data type
         ErrorLog "You are attempting to enter a value that" & _
                  " is a different data type than declared in the DB."

      Case Else
         ErrorLog Err.Number & Err.Description

   End Select

End Sub

Public Sub ErrorLog(strMsg As String)

  ' Retrieve a reference id for the file
  Dim intErrorLog As Integer
  intErrorLog = FreeFile

  ' Open the log for append
  Open App.Path & "\error.log" For Append As intErrorLog

  ' Print to the error log
  Print #intErrorLog, Now() & " : " & strMsg

  'Close the error log
  Close intErrorLog

  ' Let the user know about the error
  MsgBox "Error: " & strMsg

End Sub

